function [residual, g1, g2, g3] = gov_simulation_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(22, 1);
T21 = params(2)^params(4);
T25 = y(9)^(params(4)-1);
T26 = x(it_, 3)*T21*T25;
T36 = T21*(y(9)*y(33))^(params(4)-1);
T48 = y(11)^(1/(1-params(4)));
T153 = 1-x(it_, 2)*x(it_, 1)/y(9);
T156 = 1-x(it_, 4)*x(it_, 1)/(y(9)*y(14));
lhs =x(it_, 2)*y(8);
rhs =1-x(it_, 4)+x(it_, 3)*y(1);
residual(1)= lhs-rhs;
lhs =y(13);
rhs =1-y(13)*T26/y(32);
residual(2)= lhs-rhs;
lhs =y(12);
rhs =1-y(12)*T36/y(31);
residual(3)= lhs-rhs;
lhs =y(11);
rhs =y(13)/y(12);
residual(4)= lhs-rhs;
lhs =y(14);
rhs =x(it_, 4)+(1-x(it_, 4))*T48;
residual(5)= lhs-rhs;
lhs =y(17);
rhs =y(12)*((1-y(3))*y(2)*y(4)+y(19)+y(29)+y(11)*(y(4)*y(3)*y(2)+y(28)));
residual(6)= lhs-rhs;
lhs =y(24);
rhs =y(12)*(y(29)+y(19)+y(2)*y(7));
residual(7)= lhs-rhs;
lhs =y(23);
rhs =y(13)*(y(28)+y(2)*y(6));
residual(8)= lhs-rhs;
lhs =y(19);
rhs =params(1)*y(21)-y(27)+x(it_, 4)*x(it_, 1)*y(34)/(y(9)*y(33));
residual(9)= lhs-rhs;
lhs =x(it_, 2)*x(it_, 1)*(x(it_, 4)+y(16)-1)*y(18)/x(it_, 4);
rhs =y(4)*y(2)*y(3)*(1-y(13))+y(21)*(x(it_, 7)+x(it_, 8))-y(13)*y(28);
residual(10)= lhs-rhs;
lhs =y(10);
rhs =params(1)*y(21);
residual(11)= lhs-rhs;
lhs =y(9);
rhs =(1-params(1))*y(21)/y(5)+1-params(3);
residual(12)= lhs-rhs;
lhs =y(21);
rhs =y(5)^(1-params(1));
residual(13)= lhs-rhs;
lhs =y(18);
rhs =y(22)+y(21)*x(it_, 5);
residual(14)= lhs-rhs;
lhs =y(26);
rhs =(1-y(3))*y(18);
residual(15)= lhs-rhs;
lhs =y(25);
rhs =y(3)*y(18);
residual(16)= lhs-rhs;
lhs =y(22)*x(it_, 1)*x(it_+1, 2);
rhs =y(5)*(1-params(3))+y(20);
residual(17)= lhs-rhs;
lhs =y(21);
rhs =y(17)+y(20)+y(21)*x(it_, 6);
residual(18)= lhs-rhs;
lhs =y(15);
rhs =T153/T156;
residual(19)= lhs-rhs;
lhs =x(it_+1, 2)*x(it_, 1)*x(it_+1, 5)*y(35);
rhs =y(21)*(x(it_, 7)+x(it_, 8))+y(21)*x(it_, 6)+y(21)*y(2)*x(it_, 5)-y(27);
residual(20)= lhs-rhs;
lhs =y(28);
rhs =y(21)*(x(it_, 7)+x(it_, 8))+x(it_, 3)*x(it_, 1)*y(36)/y(9);
residual(21)= lhs-rhs;
lhs =y(29);
rhs =(1-x(it_, 4))*x(it_, 1)*y(36)*y(30)/(y(8)*y(9)*y(33))+x(it_, 4)*x(it_, 1)*y(37)/(y(9)*y(33));
residual(22)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(22, 45);

  %
  % Jacobian matrix
  %

T213 = getPowerDeriv(y(9)*y(33),params(4)-1,1);
  g1(1,1)=(-x(it_, 3));
  g1(1,8)=x(it_, 2);
  g1(1,39)=y(8);
  g1(1,40)=(-y(1));
  g1(1,41)=1;
  g1(2,9)=y(13)*x(it_, 3)*T21*getPowerDeriv(y(9),params(4)-1,1)/y(32);
  g1(2,13)=1-(-(T26/y(32)));
  g1(2,32)=(-(y(13)*T26))/(y(32)*y(32));
  g1(2,40)=y(13)*T21*T25/y(32);
  g1(3,9)=y(12)*T21*y(33)*T213/y(31);
  g1(3,12)=1-(-(T36/y(31)));
  g1(3,31)=(-(y(12)*T36))/(y(31)*y(31));
  g1(3,33)=y(12)*T21*y(9)*T213/y(31);
  g1(4,11)=1;
  g1(4,12)=(-((-y(13))/(y(12)*y(12))));
  g1(4,13)=(-(1/y(12)));
  g1(5,11)=(-((1-x(it_, 4))*getPowerDeriv(y(11),1/(1-params(4)),1)));
  g1(5,14)=1;
  g1(5,41)=(-(1-T48));
  g1(6,2)=(-(y(12)*((1-y(3))*y(4)+y(11)*y(3)*y(4))));
  g1(6,11)=(-(y(12)*(y(4)*y(3)*y(2)+y(28))));
  g1(6,12)=(-((1-y(3))*y(2)*y(4)+y(19)+y(29)+y(11)*(y(4)*y(3)*y(2)+y(28))));
  g1(6,3)=(-(y(12)*(y(4)*(-y(2))+y(11)*y(2)*y(4))));
  g1(6,17)=1;
  g1(6,4)=(-(y(12)*((1-y(3))*y(2)+y(11)*y(3)*y(2))));
  g1(6,19)=(-y(12));
  g1(6,28)=(-(y(12)*y(11)));
  g1(6,29)=(-y(12));
  g1(7,2)=(-(y(12)*y(7)));
  g1(7,12)=(-(y(29)+y(19)+y(2)*y(7)));
  g1(7,19)=(-y(12));
  g1(7,24)=1;
  g1(7,7)=(-(y(12)*y(2)));
  g1(7,29)=(-y(12));
  g1(8,2)=(-(y(13)*y(6)));
  g1(8,13)=(-(y(28)+y(2)*y(6)));
  g1(8,23)=1;
  g1(8,6)=(-(y(13)*y(2)));
  g1(8,28)=(-y(13));
  g1(9,9)=(-((-(y(33)*x(it_, 4)*x(it_, 1)*y(34)))/(y(9)*y(33)*y(9)*y(33))));
  g1(9,33)=(-((-(y(9)*x(it_, 4)*x(it_, 1)*y(34)))/(y(9)*y(33)*y(9)*y(33))));
  g1(9,19)=1;
  g1(9,34)=(-(x(it_, 4)*x(it_, 1)/(y(9)*y(33))));
  g1(9,21)=(-params(1));
  g1(9,27)=1;
  g1(9,38)=(-(x(it_, 4)*y(34)/(y(9)*y(33))));
  g1(9,41)=(-(x(it_, 1)*y(34)/(y(9)*y(33))));
  g1(10,2)=(-(y(4)*y(3)*(1-y(13))));
  g1(10,13)=(-(y(4)*y(2)*(-y(3))-y(28)));
  g1(10,3)=(-(y(4)*y(2)*(1-y(13))));
  g1(10,16)=x(it_, 2)*x(it_, 1)*y(18)/x(it_, 4);
  g1(10,4)=(-(y(2)*y(3)*(1-y(13))));
  g1(10,18)=x(it_, 2)*x(it_, 1)*(x(it_, 4)+y(16)-1)/x(it_, 4);
  g1(10,21)=(-(x(it_, 7)+x(it_, 8)));
  g1(10,28)=y(13);
  g1(10,38)=y(18)*x(it_, 2)*(x(it_, 4)+y(16)-1)/x(it_, 4);
  g1(10,39)=y(18)*x(it_, 1)*(x(it_, 4)+y(16)-1)/x(it_, 4);
  g1(10,41)=(x(it_, 4)*x(it_, 2)*x(it_, 1)*y(18)-x(it_, 2)*x(it_, 1)*(x(it_, 4)+y(16)-1)*y(18))/(x(it_, 4)*x(it_, 4));
  g1(10,44)=(-y(21));
  g1(10,45)=(-y(21));
  g1(11,10)=1;
  g1(11,21)=(-params(1));
  g1(12,9)=1;
  g1(12,21)=(-((1-params(1))*1/y(5)));
  g1(12,5)=(-((1-params(1))*(-y(21))/(y(5)*y(5))));
  g1(13,21)=1;
  g1(13,5)=(-(getPowerDeriv(y(5),1-params(1),1)));
  g1(14,18)=1;
  g1(14,21)=(-x(it_, 5));
  g1(14,22)=(-1);
  g1(14,42)=(-y(21));
  g1(15,3)=y(18);
  g1(15,18)=(-(1-y(3)));
  g1(15,26)=1;
  g1(16,3)=(-y(18));
  g1(16,18)=(-y(3));
  g1(16,25)=1;
  g1(17,20)=(-1);
  g1(17,5)=(-(1-params(3)));
  g1(17,22)=x(it_, 1)*x(it_+1, 2);
  g1(17,38)=y(22)*x(it_+1, 2);
  g1(17,39)=x(it_, 1)*y(22);
  g1(18,17)=(-1);
  g1(18,20)=(-1);
  g1(18,21)=1-x(it_, 6);
  g1(18,43)=(-y(21));
  g1(19,9)=(-((T156*(-((-(x(it_, 2)*x(it_, 1)))/(y(9)*y(9))))-T153*(-((-(y(14)*x(it_, 4)*x(it_, 1)))/(y(9)*y(14)*y(9)*y(14)))))/(T156*T156)));
  g1(19,14)=(-((-(T153*(-((-(y(9)*x(it_, 4)*x(it_, 1)))/(y(9)*y(14)*y(9)*y(14))))))/(T156*T156)));
  g1(19,15)=1;
  g1(19,38)=(-((T156*(-(x(it_, 2)/y(9)))-T153*(-(x(it_, 4)/(y(9)*y(14)))))/(T156*T156)));
  g1(19,39)=(-((-(x(it_, 1)/y(9)))/T156));
  g1(19,41)=(-((-(T153*(-(x(it_, 1)/(y(9)*y(14))))))/(T156*T156)));
  g1(20,2)=(-(y(21)*x(it_, 5)));
  g1(20,21)=(-(x(it_, 7)+x(it_, 8)+x(it_, 6)+y(2)*x(it_, 5)));
  g1(20,35)=x(it_+1, 2)*x(it_, 1)*x(it_+1, 5);
  g1(20,27)=1;
  g1(20,38)=x(it_+1, 2)*x(it_+1, 5)*y(35);
  g1(20,39)=x(it_, 1)*x(it_+1, 5)*y(35);
  g1(20,42)=(-(y(2)*y(21)));
  g1(20,42)=x(it_+1, 2)*x(it_, 1)*y(35);
  g1(20,43)=(-y(21));
  g1(20,44)=(-y(21));
  g1(20,45)=(-y(21));
  g1(21,9)=(-((-(x(it_, 3)*x(it_, 1)*y(36)))/(y(9)*y(9))));
  g1(21,21)=(-(x(it_, 7)+x(it_, 8)));
  g1(21,28)=1;
  g1(21,36)=(-(x(it_, 3)*x(it_, 1)/y(9)));
  g1(21,38)=(-(x(it_, 3)*y(36)/y(9)));
  g1(21,40)=(-(x(it_, 1)*y(36)/y(9)));
  g1(21,44)=(-y(21));
  g1(21,45)=(-y(21));
  g1(22,8)=(-((1-x(it_, 4))*(-(y(9)*y(33)*x(it_, 1)*y(36)*y(30)))/(y(8)*y(9)*y(33)*y(8)*y(9)*y(33))));
  g1(22,9)=(-((1-x(it_, 4))*(-(x(it_, 1)*y(36)*y(30)*y(8)*y(33)))/(y(8)*y(9)*y(33)*y(8)*y(9)*y(33))+(-(y(33)*x(it_, 4)*x(it_, 1)*y(37)))/(y(9)*y(33)*y(9)*y(33))));
  g1(22,30)=(-((1-x(it_, 4))*x(it_, 1)*y(36)/(y(8)*y(9)*y(33))));
  g1(22,33)=(-((1-x(it_, 4))*(-(x(it_, 1)*y(36)*y(30)*y(8)*y(9)))/(y(8)*y(9)*y(33)*y(8)*y(9)*y(33))+(-(y(9)*x(it_, 4)*x(it_, 1)*y(37)))/(y(9)*y(33)*y(9)*y(33))));
  g1(22,36)=(-((1-x(it_, 4))*x(it_, 1)*y(30)/(y(8)*y(9)*y(33))));
  g1(22,29)=1;
  g1(22,37)=(-(x(it_, 4)*x(it_, 1)/(y(9)*y(33))));
  g1(22,38)=(-((1-x(it_, 4))*y(36)*y(30)/(y(8)*y(9)*y(33))+x(it_, 4)*y(37)/(y(9)*y(33))));
  g1(22,41)=(-((-(x(it_, 1)*y(36)*y(30)/(y(8)*y(9)*y(33))))+x(it_, 1)*y(37)/(y(9)*y(33))));

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],22,2025);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],22,91125);
end
end
end
end
